import pygame
import subprocess
import sys

pygame.init()

SCREEN_WIDTH = 800
SCREEN_HEIGHT = 600
screen = pygame.display.set_mode((SCREEN_WIDTH, SCREEN_HEIGHT))
pygame.display.set_caption("2dForAll – Hauptmenü")

WHITE = (255, 255, 255)
BLUE = (50, 100, 255)
GREEN = (0, 200, 0)
RED = (200, 0, 0)

font = pygame.font.SysFont("Arial", 50)
button_font = pygame.font.SysFont("Arial", 35)

def draw_button(text, x, y, width, height, color):
    rect = pygame.Rect(x, y, width, height)
    pygame.draw.rect(screen, color, rect)
    text_surface = button_font.render(text, True, WHITE)
    screen.blit(
        text_surface,
        (x + width // 2 - text_surface.get_width() // 2,
         y + height // 2 - text_surface.get_height() // 2)
    )
    return rect

running = True
while running:
    screen.fill(BLUE)

    title = font.render("2D For All – Hauptmenü", True, WHITE)
    screen.blit(title, (SCREEN_WIDTH // 2 - title.get_width() // 2, 50))

    btn1 = draw_button("Level 1 starten", 250, 200, 300, 70, GREEN)
    btn2 = draw_button("Level 2 starten", 250, 280, 300, 70, GREEN)
    btn3 = draw_button("Level 3 starten", 250, 360, 300, 70, GREEN)
    btn_quit = draw_button("Beenden", 250, 440, 300, 70, RED)

    for event in pygame.event.get():
        if event.type == pygame.QUIT:
            running = False

        if event.type == pygame.MOUSEBUTTONDOWN and event.button == 1:
            mx, my = pygame.mouse.get_pos()

            if btn1.collidepoint(mx, my):
                pygame.quit()
                subprocess.call([sys.executable, "level/level1.py"])
                sys.exit()

            elif btn2.collidepoint(mx, my):
                pygame.quit()
                subprocess.call([sys.executable, "level/level2.py"])
                sys.exit()

            elif btn3.collidepoint(mx, my):
                pygame.quit()
                subprocess.call([sys.executable, "level/level3.py"])
                sys.exit()

            elif btn_quit.collidepoint(mx, my):
                running = False

    pygame.display.flip()

pygame.quit()

