import pygame, random, time, json, os
import tkinter as tk


# Pfad zur JSON-Datei
DATA_PATH = os.path.join("..", "data", "infoplayer1.json")

# JSON laden
with open(DATA_PATH, "r") as f:
    player_data = json.load(f)

# Werte aus JSON übernehmen
player_name = player_data["name"]
player_age = player_data["alter"]
has_sword = player_data["sword"]
coin_count = player_data["coins"]

# ... dein Spielcode hier ...

# Am Ende oder wenn du speichern willst:
player_data["coins"] = coin_count
player_data["sword"] = has_sword

with open(DATA_PATH, "w") as f:
    json.dump(player_data, f, indent=4)

pygame.init()
pygame.mixer.init()

jump_sound = pygame.mixer.Sound("../sounds/fg/jump.wav")
jump_sound.set_volume(0.1)
coin_sound = pygame.mixer.Sound("../sounds/fg/coins.wav")
coin_sound.set_volume(0.5)
pause_sound = pygame.mixer.Sound("../sounds/fg/menue.wav")
pause_sound.set_volume(3.0)
game_over_sound = pygame.mixer.Sound("../sounds/fg/gameover.wav")
game_over_sound.set_volume(10.0)

# Screen
SCREEN_WIDTH = 800
SCREEN_HEIGHT = 600
screen = pygame.display.set_mode((SCREEN_WIDTH, SCREEN_HEIGHT))
pygame.display.set_caption("Elias 2D Game")

# Farben
BLUE = (0, 0, 255)
GREEN = (0, 255, 0)
RED = (255, 0, 0)
WHITE = (255, 255, 255)
BROWN = (120, 50, 7)
LIVES = (0, 150, 0)
STONE = (40, 40, 40)
BG = (70, 110, 255)
GOLD = (255, 215, 0)

# Spieler
player_x = 100
player_y = 300
player_size = 50
VELOCITY = 3
GRAVITY = 0.5
velocity_y = 0
is_jumping = False
JUMP_STRENGTH = 10
lives = 3

# Gegner
enemy_x = 640
enemy_y = 500
enemy_size = 30
ENEMY_VELOCITY = 2
enemy_direction = 1

# Coins
coin_count = 0
def münze(x, y, value):
    return (x, y, 15, value)

coins = [
    münze(200, 500, 1),
    münze(350, 450, 3),
    münze(100, 300, 5),
]

# Kisten
chests = []
def makeChest(x, y, coinsin):
    chest = {
        "x": x,
        "y": y,
        "width": 32,
        "height": 32,
        "coins": coinsin,
        "collected": False,
        "rect": pygame.Rect(x, y, 32, 32)
    }
    chests.append(chest)

makeChest(400, 500, 5)
makeChest(600, 400, 10)

# Tür
door_image = pygame.image.load("../images/tür.jpg").convert_alpha()
door_image = pygame.transform.scale(door_image, (50, 100))
door_rect = pygame.Rect(50, 230, 50, 100)

# Kisten-Bild
chest_image = pygame.image.load("../images/package.png").convert_alpha()
chest_image = pygame.transform.scale(chest_image, (50, 50))  # Kistenbild skalieren

# Wasser-Bild laden
water_image = pygame.image.load("../images/wasser.jpg").convert_alpha()
water_image = pygame.transform.scale(water_image, (70, 70))  # Wasserbild skalieren

stone_image = pygame.image.load("../images/textur_stone.png").convert_alpha()
stone_image = pygame.transform.scale(stone_image, (30, 30))  # steinbild skalieren

# Partikel
class Particle:
    def __init__(self, x, y, color):
        self.x = x
        self.y = y
        self.color = color
        self.size = random.randint(3,5)
        self.life = random.randint(10,30)
        self.velocity_x = random.uniform(-1,1)
        self.velocity_y = random.uniform(-1,1)
    def move(self):
        self.x += self.velocity_x
        self.y += self.velocity_y
        self.life -= 1
    def draw(self, screen):
        if self.life > 0:
            pygame.draw.circle(screen, self.color, (int(self.x), int(self.y)), self.size)

particles = []
def create_particles(x, y, color):
    for _ in range(10):
        particles.append(Particle(x, y, color))

# Blöcke zeichnen
PIXEL_SIZE = 5
GRASS_HEIGHT = 10

def makeblock(screen, x, y, size, color):
    num_pixels = size // PIXEL_SIZE
    for px in range(num_pixels):
        for py in range(num_pixels):
            draw_x = x + px * PIXEL_SIZE
            draw_y = y + py * PIXEL_SIZE
            if color == GREEN:
                if py * PIXEL_SIZE < GRASS_HEIGHT:
                    pixel_color = GREEN
                else:
                    pixel_color = BROWN
            else:
                pixel_color = color
            pygame.draw.rect(screen, pixel_color, (draw_x, draw_y, PIXEL_SIZE, PIXEL_SIZE))

# Pause
def open_pause_menu():
    pause_sound.play()
    pause_root = tk.Tk()
    pause_root.title("Pause")
    tk.Label(pause_root, text="PAUSE", font=("Arial", 18)).pack(pady=10)
    def resume():
        pause_root.destroy()
    def exit_game():
        pause_root.destroy()
        pygame.quit()
        quit()
    tk.Button(pause_root, text="Weiter", width=20, command=resume).pack(pady=5)
    tk.Button(pause_root, text="Exit", width=20, command=exit_game).pack(pady=5)
    pause_root.mainloop()

# Kollisionsprüfung
def check_collision(x, y, blocks):
    for block in blocks:
        bx, by, bsize, bcolor, triggered = block
        if x + player_size > bx and x < bx + bsize:
            if y + player_size >= by and y + player_size <= by + 10:
                return block
    return None

# Lebensanzeige
def draw_lives(screen, lives):
    font = pygame.font.SysFont('Arial', 30)
    text = font.render(f"Leben: {lives}", True, WHITE)
    screen.blit(text, (10, 10))

# Gegner
def move_enemy():
    global enemy_x, enemy_direction
    enemy_x += ENEMY_VELOCITY * enemy_direction
    if enemy_x <= 0 or enemy_x >= SCREEN_WIDTH - enemy_size:
        enemy_direction *= -1

def push_enemy():
    global enemy_x
    if abs(player_x - enemy_x) < 30:
        enemy_x += 10
        if enemy_x > SCREEN_WIDTH:
            enemy_x = -enemy_size

# Blockliste: (x, y, width, color, triggered)
blocks = [
    (0, 540, 70, BLUE, False), (70, 540, 70, BLUE, False), (140, 540, 70, BLUE, False),
    (210, 540, 70, BLUE, False), (280, 540, 70, BLUE, False), (350, 540, 70, BLUE, False),
    (420, 540, 70, BLUE, False), (490, 540, 70, BLUE, False), (560, 540, 70, BLUE, False),
    (630, 540, 70, BLUE, False), (700, 540, 70, BLUE, False),

    (0, 530, 50, GREEN, False), (50, 530, 50, GREEN, False), (100, 530, 50, GREEN, False),
    (150, 530, 50, GREEN, False), (200, 530, 50, GREEN, False), (250, 530, 50, GREEN, False),
    (300, 530, 50, GREEN, False), (420, 530, 300, GREEN, False),

    (50, 490, 50, BROWN, False), (50, 440, 50, BROWN, False),
    (50, 390, 50, BROWN, False), (50, 340, 50, BROWN, False),

    (0, 290, 60, LIVES, False), (0, 350, 60, LIVES, False),
    (60, 290, 60, LIVES, False), (60, 350, 60, LIVES, False),

    (300, 455, 30, 'stone', False),  # Verwende das Bild anstelle der Farbe

    (670, 520, 100, RED, False),

    (20, 400, 20, BROWN, False),
    (20, 360, 20, BROWN, False),
    (20, 320, 20, BROWN, False),
    (20, 280, 20, BROWN, False),
    (0, 250, 60, GREEN, False),
    (0, 220, 60, GREEN, False)
]

# Hauptschleife
running = True
while running:
    keys = pygame.key.get_pressed()
    for event in pygame.event.get():
        if event.type == pygame.QUIT:
            running = False
        if event.type == pygame.KEYDOWN:
            if event.key == pygame.K_p:
                open_pause_menu()
            if event.key == pygame.K_f:
                push_enemy()

    # Bewegung
    if keys[pygame.K_a]:
        player_x -= VELOCITY
    if keys[pygame.K_d]:
        player_x += VELOCITY

    # Sprung starten
    if keys[pygame.K_w] and not is_jumping:
        velocity_y = -JUMP_STRENGTH
        is_jumping = True
        jump_sound.play()  # 🔊 Sprungsound abspielen

    # Schwerkraft
    player_y += velocity_y
    velocity_y += GRAVITY

    # Kollisionsprüfung
    block = check_collision(player_x, player_y, blocks)
    if block:
        bx, by, bsize, bcolor, triggered = block
        if bcolor == RED and not triggered:
            lives -= 1
            print(f"Rote Zone ausgelöst! Leben: {lives}")
            blocks[blocks.index(block)] = (bx, by, bsize, GREEN, True)
            player_y = by - player_size
            velocity_y = 0
            is_jumping = False
            makeChest(bx + bsize//2 - 16, by - 60 - 32, 20)
        elif bcolor != BLUE:
            player_y = by - player_size
            velocity_y = 0
            is_jumping = False
            if bcolor == GREEN:
                create_particles(player_x + player_size // 2, player_y + player_size // 2, GREEN)
        elif bcolor == BLUE:
            pygame.quit()
            quit()
    else:
        if player_y + player_size > SCREEN_HEIGHT:
            player_y = SCREEN_HEIGHT - player_size
            velocity_y = 0
            is_jumping = False

    move_enemy()

    # Spielerrechteck
    player_rect = pygame.Rect(player_x, player_y, player_size, player_size)

    for coin in coins[:]:
        cx, cy, cr, value = coin
        coin_rect = pygame.Rect(cx - cr, cy - cr, cr*2, cr*2)
        if player_rect.colliderect(coin_rect):
            coins.remove(coin)
            coin_count += value
            coin_sound.play()  # 🔊 Coinsound

    for chest in chests:
        if not chest["collected"] and player_rect.colliderect(chest["rect"]):
            coin_count += chest["coins"]
            chest["collected"] = True
            coin_sound.play()  # 🔊 Coinsound
            create_particles(
                chest["x"] + chest["width"]//2,
                chest["y"] + chest["height"]//2,
                GOLD
            )

    # Tür betreten
    if player_rect.colliderect(door_rect) and keys[pygame.K_RETURN]:
        open_pause_menu()

    # Partikel bewegen
    for particle in particles[:]:
        particle.move()
        if particle.life <= 0:
            particles.remove(particle)

    # Zeichnen
    screen.fill(BG)
    for bx, by, bsize, bcolor, triggered in blocks:
        if bcolor == 'stone':
            # Steinblock durch das Bild ersetzen
            screen.blit(stone_image, (bx, by))  # Steinbild an der Position des Blocks zeichnen
        else:
            makeblock(screen, bx, by, bsize, bcolor)

    for cx, cy, cr, value in coins:
        pygame.draw.circle(screen, GOLD, (cx, cy), cr)
    for chest in chests:
        if not chest["collected"]:
            screen.blit(chest_image, (chest["x"], chest["y"]))  # Kistenbild anzeigen
    screen.blit(door_image, (door_rect.x, door_rect.y))
    for particle in particles:
        particle.draw(screen)
    pygame.draw.rect(screen, RED, (player_x, player_y, player_size, player_size))
    draw_lives(screen, lives)
    font = pygame.font.SysFont('Arial', 30)
    text = font.render(f"Coins: {coin_count}", True, WHITE)
    screen.blit(text, (10, 50))

    pygame.display.flip()

pygame.quit()
