import tkinter as tk

sounds = ["DGDG"]
root = tk.Tk()
root.title("Game Menu")

button_frame = tk.Frame(root)
button_frame.pack(pady=20)

status_label = tk.Label(root, text="", fg="blue")
status_label.pack(side="bottom", fill="x")

def thing(widget_class, bg, fg, text, column):
    widget = widget_class(button_frame, text=text, bg=bg, fg=fg)

    def on_enter(event):
        status_label.config(text=f"Hallo {text}!")

    def on_leave(event):
        status_label.config(text="")

    widget.bind("<Enter>", on_enter)
    widget.bind("<Leave>", on_leave)

    widget.grid(row=0, column=column, padx=10, pady=10)
    return widget

thing(tk.Button, "navy", "white", "sounds", 0)
thing(tk.Button, "navy", "white", "images", 1)
thing(tk.Button, "navy", "white", "level", 2)

root.mainloop()